from django import forms
from django.contrib.auth import authenticate
from django.contrib.auth.forms import AuthenticationForm
from django.contrib.auth.models import User
from django.core.exceptions import ObjectDoesNotExist
from django.core.exceptions import ValidationError

from App.loyaltyMe.models import Place, Beacon
from App.promotion.models import Promotion


class EmailAuthenticationForm(AuthenticationForm):
    def clean_username(self):
        username = self.data['username']
        if '@' in username:
            try:
                username = User.objects.get(email=username).username
            except ObjectDoesNotExist:
                raise ValidationError(
                        self.error_messages['invalid_login'],
                        code='invalid_login',
                        params={'username': self.username_field.verbose_name},
                )
        return username


class PlaceForm(forms.ModelForm):
    class Meta:
        model = Place
        fields = '__all__'
        exclude = ['owners', 'promotion', 'offer', 'screen_img', 'logo_img', 'localization']

    def __init__(self, user, *args, **kwargs):
        super(PlaceForm, self).__init__(*args, **kwargs)
        self.fields['beacon'].queryset = Beacon.objects.filter(user=user)


class PromotionForm(forms.ModelForm):
    class Meta:
        model = Promotion
        exclude = ['status', 'code']