from django.test import TestCase, RequestFactory

from rest_framework.test import APIRequestFactory

# Using the standard RequestFactory API to create a form POST request
from App.loyaltyMe.models import Product
from App.loyaltyMe.serializers import ProductSerializer
from App.loyaltyMe.test_data.products import PRODUCTS_SAMPLE_DATA, PRODUCTS_SAMPLE_SERIALIZED_DATA


class ProductSerializerTestCase(TestCase):
    def setUp(self):
        self.product_data = PRODUCTS_SAMPLE_DATA[0]
        self.product_data_serialized = PRODUCTS_SAMPLE_SERIALIZED_DATA[0]
        self.product = Product.objects.create(**self.product_data)

    def test_serializer(self):
        context = dict(request=RequestFactory().get('/'))
        serializer = ProductSerializer(self.product, context=context)
        self.assertEqual(serializer.data, self.product_data_serialized)