import rest_framework
from django.test import TestCase

from App.user.serializers import AuthTokenSerializerByEmail
from django.contrib.auth.models import User

from App.user.test_data.users import USERS_SAMPLE_DATA


class AuthTokenSerializerByEmailTestCase(TestCase):
    def setUp(self):
        self.auth_by_email = AuthTokenSerializerByEmail()
        user = USERS_SAMPLE_DATA[0]
        self.test_user = User.objects.create_user(username=user[0], password=user[1], email=user[2], is_active=True,
                                           is_superuser=True, is_staff=True, )
        self.test_user.save()


    def test_success_validate(self):
        test = {'email':'admin@gmail.com', 'password':'admin'}
        validation = self.auth_by_email.validate(test)
        self.assertIn('user', validation)

    def test_fail_validate_wrong_password(self):
        test = {'email':'admin@gmail.com', 'password':'admin12'}
        self.assertRaises(rest_framework.exceptions.ValidationError,self.auth_by_email.validate, test )

    def test_fail_validate_user_not_exist(self):
        test = {'email':'admined2@gmail.com', 'password':'admin12'}
        self.assertRaises(rest_framework.exceptions.ValidationError,self.auth_by_email.validate, test )

    def test_fail_validate_lack_of_data(self):
        test = {'email':'admin@gmail.com', }
        self.assertRaises(rest_framework.exceptions.ValidationError,self.auth_by_email.validate, test)

    def test_fail_validate_user_blocked(self):
        self.test_user.is_active = False
        self.test_user.save()
        test = {'email':'admin@gmail.com', 'password':'admin'}
        self.assertRaises(rest_framework.exceptions.ValidationError,self.auth_by_email.validate, test )