import django_filters
from django.shortcuts import render

# Create your views here.
from rest_framework import viewsets, permissions, filters
from rest_framework.decorators import api_view
from rest_framework.decorators import renderer_classes
from rest_framework_swagger.renderers import SwaggerUIRenderer, OpenAPIRenderer
from rest_framework import response, schemas


from App.promotion.models import UserPromotion, UserTask, Promotion, PromotionSet, Task
from App.promotion.serializers import UserTaskSerializer, UserPromotionSerializer, PromotionSerializer, \
    PromotionSetSerializer, TaskSerializer


class UserPromotionFilter(filters.FilterSet):
    place = django_filters.CharFilter(name="place__id")

    class Meta:
        model = UserPromotion
        fields = ['place']


class UserPromotionViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = UserPromotion.objects.all()
    serializer_class = UserPromotionSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)
    filter_backends = (filters.DjangoFilterBackend,)
    filter_class = UserPromotionFilter

    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return UserPromotion.objects.filter(user=user)

class UserTaskViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = UserTask.objects.all()
    serializer_class = UserTaskSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)
    filter_backends = (filters.DjangoFilterBackend,)

    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return UserTask.objects.filter(user=user)


class PromotionViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Promotion.objects.all()
    serializer_class = PromotionSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)


class PromotionSetViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = PromotionSet.objects.all()
    serializer_class = PromotionSetSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

class TaskViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Task.objects.all()
    serializer_class = TaskSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

