import rest_framework
from django.db.models import Q
from rest_framework import viewsets, permissions
from rest_framework.decorators import detail_route
from rest_framework.response import Response

from App.loyaltyMe.models import Product, Offer, Place, Localization, Beacon
from App.loyaltyMe.serializers import ProductSerializer, OfferSerializer, PlaceSerializer, \
    LocalizationSerializer, BeaconSerializer
from App.promotion.models import UserPromotion


class ProductViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Product.objects.all()
    serializer_class = ProductSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)


class OfferViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Offer.objects.all()
    serializer_class = OfferSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)


class PlaceViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Place.objects.all()
    serializer_class = PlaceSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    @detail_route(methods=['get'])
    def refresh(self, request, pk=None):
        user = request.user
        place = Place.objects.filter(pk=pk)[0]
        user_promotions = UserPromotion.objects.filter(Q(user=user) & Q(place=place))
        for user_promotion in user_promotions:
            user_promotion.update_user_task()
        return Response(status=rest_framework.status.HTTP_200_OK)


class LocalizationViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Localization.objects.all()
    serializer_class = LocalizationSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)


class BeaconViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Beacon.objects.all()
    serializer_class = BeaconSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)
