from rest_framework import serializers

from App.loyaltyMe.models import Product, Offer, Promotion, Place, Localization, Beacon


class ProductSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Product
        fields = ('url', 'id', 'name', 'description', 'price', 'img')


class OfferSerializer(serializers.HyperlinkedModelSerializer):
    products = ProductSerializer(many=True)

    class Meta:
        model = Offer
        fields = ('url', 'id', 'products')


class PromotionSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Promotion
        fields = ('url', 'id', 'name', 'description', 'code', 'img', 'status', 'left_number', 'start_date', 'end_date')


class PromotionSetSerializer(serializers.HyperlinkedModelSerializer):
    promotions = PromotionSerializer(many=True)

    class Meta:
        model = Offer
        fields = ('url', 'id', 'promotions')


class LocalizationSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Localization
        fields = ('url', 'id', 'latitude', 'longitude', 'city', 'road', 'road_number')


class BeaconSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Beacon
        fields = ('url', 'id', 'uuid', 'major', 'minor', 'name', 'description')

class PlaceSerializer(serializers.HyperlinkedModelSerializer):
    offer = OfferSerializer()
    promotion = PromotionSetSerializer()
    localization = LocalizationSerializer()
    beacon = BeaconSerializer()

    class Meta:
        model = Place
        fields = ('url', 'id', 'name', 'type', 'screen_img', 'logo_img', 'description', 'offer', 'promotion', 'localization' ,'beacon')
