from rest_framework import serializers

from App.loyaltyMe.models import Product, Offer, Promotion, Place


class ProductSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Product
        fields = ('url', 'id', 'name', 'description', 'price', 'img')

class OfferSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Offer
        fields = ('url', 'id', 'products')

class PromotionSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Promotion
        fields = ('url', 'id', 'name', 'description', 'code', 'img', 'status')

class PlaceSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Place
        fields = ('url', 'id', 'name', 'type', 'screen_img', 'logo_img', 'description', 'offer', 'promotions')