from datetime import timedelta, datetime

from django.contrib.auth.models import User
from django.db import models
from django.db.models.signals import post_save
from django.dispatch import receiver
from rest_framework.authtoken.models import Token
from django.test import TestCase
# Create your models here.
from App.loyaltyMe.models import Place, Promotion, Task
from django.utils import timezone


@receiver(post_save, sender=User)
def create_auth_token(sender, instance=None, created=False, **kwargs):
    if created:
        Token.objects.create(user=instance)


class UserProfile(models.Model):
    user = models.ForeignKey(User, related_name='user_profile',
                             blank=False, null=False, default=None)
    photo = models.ImageField()


class UserTask(models.Model):
    task = models.ForeignKey(Task)
    user = models.ForeignKey(User, related_name='user_task',
                             blank=False, null=False, default=None)
    done = models.BooleanField(default=False)
    last_update = models.DateTimeField()
    counter = models.IntegerField()  # akutalnie bylem 3 razy # aktualny status uzytkwonika w zadaniu
    beacon_counter = models.IntegerField()  # juz 10 minut, jeszcze raz i bedzie hyvka # status czy zaliczyc z beaconow taska
    beacon_signal_last_update = models.DateTimeField()  # ostatnio 23 h temu # last update

    def update(self):
        if not self.ready_to_update():
            return False
        if self.done:
            return False
        if self.task_delay_passed():
            self.counter += self.task.counter_incrementation
        if self.counter == self.task.counter_target:
            self.done = True
            return True
        return False

    def ready_to_update(self):
        if self.maximum_beacon_delay_passed():
            self.beacon_counter = 0
        if self.beacon_delay_passed():
            self.beacon_counter = +1
            self.beacon_signal_last_update = timezone.now()
        if self.beacon_counter == self.task.beacon_counter_target:
            self.beacon_counter = 0
            return True
        return False

    def maximum_beacon_delay_passed(self):
        return self.delay_passed(self.beacon_signal_last_update, self.task.beacon_singal_delay_maximum_delay)

    def beacon_delay_passed(self):
        return self.delay_passed(self.beacon_signal_last_update, self.task.beacon_signal_delay)

    def task_delay_passed(self):
        return self.delay_passed(self.last_update, self.task.update_delay)

    def delay_passed(self, last_update, signal_delay):
        actual_time = timezone.now()
        time_difference = actual_time - last_update
        return time_difference > signal_delay


class UserPromotion(models.Model):
    USED = 'US'
    ACTIVE = 'AC'
    NON_AVAILABLE = 'NAV'
    AVAILABLE = 'AV'

    PROGRESS_CHOICES = (
        (USED, 'Used'),
        (ACTIVE, 'Active'),
        (NON_AVAILABLE, 'Non Available'),
        (AVAILABLE, 'Available'),
    )

    user = models.ForeignKey(User, related_name='user_promotion',
                             blank=False, null=False, default=None)
    place = models.ForeignKey(Place)
    promotion = models.ForeignKey(Promotion)
    progress = models.CharField(max_length=2, choices=PROGRESS_CHOICES, default=ACTIVE)
    code = models.CharField(max_length=20, null=True)
    user_task = models.ForeignKey(UserTask)

    def update_user_task(self):
        self.user_task.update()
