from django.db import models
from django.contrib.auth.models import User
from django.db.models.signals import post_save
from django.dispatch import receiver
from django.utils import timezone
from rest_framework.authtoken.models import Token
from datetime import timedelta

# Create your models here.
from App.loyaltyMe.models import Place, Promotion, Task


@receiver(post_save, sender=User)
def create_auth_token(sender, instance=None, created=False, **kwargs):
    if created:
        Token.objects.create(user=instance)


class UserProfile(models.Model):
    user = models.ForeignKey(User, related_name='user_profile',
                             blank=False, null=False, default=None)
    photo = models.ImageField()


class UserPromotion(models.Model):
    user = models.ForeignKey(User, related_name='user_promotion',
                             blank=False, null=False, default=None)
    place = models.ForeignKey(Place)
    promotion = models.ForeignKey(Promotion)
    status = models.CharField(max_length=30)
    code = models.CharField(max_length=20, null=True)



class UserTask(models.Model):
    task = models.ForeignKey(Task)
    user = models.ForeignKey(User, related_name='user_task',
                             blank=False, null=False, default=None)
    done = models.BooleanField(default=False)
    last_update = models.DateField()
    counter = models.DurationField()
    beacon_counter = models.DurationField()
    beacon_signal_last_update = models.DateField()

    def update(self):
        if not self.beacon_delay_passed():
            return
        if self.done:
            return
        if self.counter == self.task.counter_target:
            self.done = True
            return
        actual_time = timezone.now()
        if actual_time + self.task.update_delay > self.last_update:
            self.counter += self.task.counter_incrementation

    def beacon_delay_passed(self):
        actual_time = timezone.now()
        if actual_time + timedelta(seconds = self.task.beacon_signal_delay) > self.beacon_signal_last_update:
            self.beacon_counter = +1
            self.beacon_signal_last_update = actual_time
        if self.beacon_counter == self.task.beacon_counter_target:
            self.beacon_counter = 0
            return True
        return False