import rest_framework
from django.contrib.auth.models import User
from django.shortcuts import render

# Create your views here.
from rest_framework import viewsets
from rest_framework.decorators import list_route
from rest_framework.response import Response
from rest_framework import viewsets, permissions
from App.user.serializers import UserSerializer


class UserViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = User.objects.all()
    serializer_class = UserSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    @list_route(methods=['get'])
    def me(self, request, pk=None):
        user = User.objects.filter(pk=request.user.id)[0]
        user_data = UserSerializer(user, context={'request': request}).data
        return Response(status=rest_framework.status.HTTP_200_OK, data= user_data)