"""KawowyDzienniczek URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from django.conf.urls import url, include
from django.contrib import admin
from rest_framework import routers

from App.loyaltyMe import views as loyalty_views
from App.page.views import coming_soon_page, main_page
from App.user import views as user_views

router = routers.DefaultRouter()
router.register(r'user', user_views.UserViewSet)
router.register(r'user_profile', user_views.UserProfileViewSet)
router.register(r'user_promotions', user_views.UserPromotionViewSet)
router.register(r'products', loyalty_views.ProductViewSet)
router.register(r'offers', loyalty_views.OfferViewSet)
router.register(r'promotions', loyalty_views.PromotionViewSet)
router.register(r'promotion_set', loyalty_views.PromotionSetViewSet)
router.register(r'places', loyalty_views.PlaceViewSet)
router.register(r'localizations', loyalty_views.LocalizationViewSet)
router.register(r'beacons', loyalty_views.BeaconViewSet)

urlpatterns = [
    url(r'^api/', include(router.urls)),
    url(r'^admin/', admin.site.urls),
    url(r'^api-auth/', include('rest_framework.urls', namespace='rest_framework')),
    url(r'^api-token-auth/', user_views.obtain_auth_token),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^$', coming_soon_page, name='post_list'),
    url(r'^main/$', main_page, name='post_list'),
]
