from datetime import datetime
from django.core.management.base import BaseCommand
from App.loyaltyMe.models import Promotion


class Command(BaseCommand):
    help = 'Closes the specified poll for voting'

    def handle(self, *args, **options):
        promotions = [
            # [name, description, code, img, status]
            ['10%', 'Zniżka 10%', '5ac5', '/static/img/photo_1.jpg', 'New', '200', None, None],
            ['20%', 'Zniżka 20%', '5ac6', '/static/img/photo_1.jpg', 'New', None, None, None],
            ['50%', 'Zniżka 50%', '5ac7', '/static/img/photo_1.jpg', 'New', '0', datetime(2016, 5, 22, 11, 30, 59),
             datetime(2017, 12, 22, 11, 30, 59)],
        ]
        print("Creating Promotions")
        for promotion in promotions:
            print('Create {0}'.format(promotion[0]))
            new_promotion = Promotion.objects.create(name=promotion[0], description=promotion[1], code=promotion[2],
                                                     img=promotion[3], status=promotion[4], left_number=promotion[5],
                                                     start_date=promotion[6], end_date=promotion[7])
            new_promotion.save()
