from rest_framework import serializers

from App.loyaltyMe.models import Offer
from App.promotion.models import Task, Promotion, UserTask, UserPromotion
from App.user.serializers import UserSerializer




class TaskSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Task
        fields = ('url', 'id', 'type', 'update_delay', 'description', 'name', 'counter_target', 'beacon_counter_target',
                  'counter_incrementation', 'beacon_signal_delay')



class PromotionSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Promotion
        fields = ('url', 'id', 'name', 'description', 'code', 'img', 'status', 'left_number', 'start_date', 'end_date')


class PromotionSetSerializer(serializers.HyperlinkedModelSerializer):
    promotions = PromotionSerializer(many=True)

    class Meta:
        model = Offer
        fields = ('url', 'id', 'name', 'promotions')

class UserPromotionSerializer(serializers.HyperlinkedModelSerializer):
    user = UserSerializer()
    promotion = PromotionSerializer()

    class Meta:
        model = UserPromotion
        fields = ('url', 'id', 'user', 'place', 'promotion', 'progress', 'code')



class UserTaskSerializer(serializers.HyperlinkedModelSerializer):
    user = UserSerializer()
    task = TaskSerializer()
    last_update = serializers.DateTimeField(format="%Y-%m-%dT%H:%M:%S")
    beacon_signal_last_update = serializers.DateTimeField(format="%Y-%m-%dT%H:%M:%S")

    class Meta:
        model = UserTask
        fields = ('url', 'id', 'task', 'user', 'done', 'last_update', 'counter', 'beacon_counter', 'beacon_signal_last_update')



