from django.contrib.auth.models import User
from django.core.management.base import BaseCommand
from django.utils import timezone

from App.promotion.models import Task, UserTask


class Command(BaseCommand):
    def handle(self, *args, **options):
        data = [
            ['Bądź u nas 10 godzin', 'Antek', True, timezone.now(), 15, 15, timezone.now()],
            ['Bądź u nas 10 godzin', 'Klaudia', False, timezone.now(), 15, 15, timezone.now()],
            ['Przyjdz 10 razy', 'admin', False, timezone.now(), 15, 15, timezone.now()],
            ['Przyjdz 10 razy', 'Klaudia', True, timezone.now(), 15, 15, timezone.now()],
        ]

        print("Creating UsersTasks")
        for user_task in data:
            print("{1} take {0} Task".format(user_task[0], user_task[1]))
            task = Task.objects.filter(name=user_task[0])[0]
            user = User.objects.filter(username=user_task[1])[0]
            counter = user_task[4]
            beacon_counter = user_task[5]
            new_usertask = UserTask.objects.create(task=task, user=user, done=user_task[2], last_update=user_task[3],
                                                   counter=counter, beacon_counter=beacon_counter,
                                                   beacon_signal_last_update=user_task[6])
            new_usertask.save()
