import sys
from io import StringIO

from django.test import TestCase
from flake8.engine import get_style_guide

from KawowyDzienniczek.settings import BASE_DIR

EXCLUDE_FROM_PEP8_TESTS = ['manage.py', '__init__.py']

# core/tests/io.py


class CaptureStdout(object):
    """
    Capture STDOUT as self.value when used as a context manager.

    Example:
        class PrintingTestCase(SimpleTestCase):
            def test_printing(self):
                with CaptureStdout() as stdout:
                    print('oh hi')
                self.assertEqual(str(stdout), 'oh hi\n')
    """

    def __init__(self):
        self.value = ''
        self.old_stdout = None

    def __str__(self):
        return self.value

    def __enter__(self):
        self.old_stdout = sys.stdout
        sys.stdout = StringIO()
        return self

    def __exit__(self, *exc_info):
        self.value = sys.stdout.getvalue()
        sys.stdout.close()
        sys.stdout = self.old_stdout


class Flake8ConformanceTestCase(TestCase):
    def test_flake8_conformance(self):
        with CaptureStdout() as stdout:
            flake8_style = get_style_guide(paths=[BASE_DIR])
            report = flake8_style.check_files()
        if report.total_errors > 0:
            self.fail(
                    'Got some flake8 errors:\n{0}'.format(stdout),
            )
