from xml import parsers

import rest_framework
from django.contrib.auth.models import User
from django.shortcuts import render

# Create your views here.
from rest_framework import viewsets
from rest_framework.authtoken.models import Token
from rest_framework.authtoken.serializers import AuthTokenSerializer
from rest_framework.decorators import list_route, detail_route
from rest_framework.response import Response
from rest_framework import viewsets, permissions
from rest_framework.views import APIView

from App.loyaltyMe.models import Place
from App.loyaltyMe.serializers import LocalizationSerializer
from App.user.models import UserProfile, UserPromotion
from App.user.serializers import UserSerializer, AuthTokenSerializerByEmail, UserProfileSerializer, \
    UserPromotionSerializer
from rest_framework import parsers, renderers


class UserViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = User.objects.all()
    serializer_class = UserSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    @list_route(methods=['get'])
    def me(self, request, pk=None):
        user = User.objects.filter(pk=request.user.id)[0]
        user_data = UserSerializer(user, context={'request': request}).data
        return Response(status=rest_framework.status.HTTP_200_OK, data=user_data)


class UserProfileViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = UserProfile.objects.all()
    serializer_class = UserProfileSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def perform_create(self, serializer):
        serializer.save(user=self.request.user)

    def list(self, request):
        user = request.user
        queryset = UserProfile.objects.exclude(user=user)
        page = self.paginate_queryset(queryset)
        serializer = UserProfileSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)

    @list_route(methods=['get'])
    def me(self, request, pk=None):
        user = request.user
        user_profile = UserProfile.objects.filter(user=user)[0]
        user_profile_data = UserProfileSerializer(user_profile, context={'request': request}).data
        return Response(status=rest_framework.status.HTTP_200_OK, data=user_profile_data)


class ObtainAuthToken(APIView):
    throttle_classes = ()
    permission_classes = ()
    parser_classes = (parsers.FormParser, parsers.MultiPartParser, parsers.JSONParser,)
    renderer_classes = (renderers.JSONRenderer,)
    serializer_class = AuthTokenSerializerByEmail

    def post(self, request, *args, **kwargs):
        serializer = self.serializer_class(data=request.data)
        serializer.is_valid(raise_exception=True)
        user = serializer.validated_data['user']
        token, created = Token.objects.get_or_create(user=user)
        return Response({'token': token.key})


obtain_auth_token = ObtainAuthToken.as_view()


# class UserPromotionViewSet(viewsets.ModelViewSet):
#     """
#     API for articles
#     """
#     queryset = UserPromotion.objects.all()
#     serializer_class = UserPromotionSerializer
#     permission_classes = (permissions.IsAuthenticatedOrReadOnly,)
#
#     def list(self, request):
#         user = request.user
#         queryset = UserPromotion.objects.filter(user=user)
#         page = self.paginate_queryset(queryset)
#         serializer = UserPromotionSerializer(page, many=True, context={'request': request})
#         return self.get_paginated_response(serializer.data)

# @list_route(methods=['post', 'get'], permission_classes=[permissions.IsAuthenticated])
# def place(self, request, pk=None):
#     place = Place.objects.filter(pk=pk)[0]
#     user_promotions = request.user.user_promotions.filter(place=place)
#     print(user_promotions)
#
#     # if (user_profile.like_counter>=award.like_needed):
#     #     user_profile.like_counter-=award.like_needed
#     #     user_profile.save()
#     #     new_user_award = UserAward.objects.create(award=award, user=request.user)
#     #     new_user_award.save()
#     #     new_user_award_data = UserAwardSerializer(new_user_award, context={'request': request}).data
#     #     return Response(status=rest_framework.status.HTTP_200_OK, data=new_user_award_data)
#     # else:
#     #     return Response(status=rest_framework.status.HTTP_405_METHOD_NOT_ALLOWED, data= "Not enough likes!")

class PlaceUserPromotionsViewSet(viewsets.ModelViewSet):
    base_name = "place_user_promotions"
    queryset = UserPromotion.objects.all()
    serializer_class = UserPromotionSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def retrieve(self, request, pk):
        place = Place.objects.filter(pk=pk)[0]
        user_promotions = request.user.user_promotion.filter(place=place)
        page = self.paginate_queryset(user_promotions)
        serializer = UserPromotionSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)

