from django.contrib.auth.models import User

from App.user.models import UserProfile

__author__ = 'Rafal'
from django.core.management.base import BaseCommand


class Command(BaseCommand):

    def handle(self, *args, **options):
        data = [
            ['admin', '/static/img/users/photos/default_avatar.png',],
            ['Antek', '/static/img/users/photos/antek.jpg',],
            ['Rafal', '/static/img/users/photos/rafal.jpg'],
            ['Klaudia', '/static/img/users/photos/klaudia.jpg'],
            ]

        print("Creating UsersProfile")
        for user_data in data:
            print("{0} take {1} API".format(user_data[0], user_data[1]))
            user = User.objects.filter(username=user_data[0])[0]
            new_userapi = UserProfile.objects.create(user=user, photo=user_data[1])
            new_userapi.save()

