from django.contrib.auth.models import User
from django.core.management.base import BaseCommand

from App.loyaltyMe.models import Place, Offer, Localization, Beacon
from App.promotion.models import PromotionSet


class Command(BaseCommand):
    help = 'Closes the specified poll for voting'

    def handle(self, *args, **options):
        places = [
            # ['name', 'type', 'screen_img', 'logo_img', 'description', 'offer', 'promotions'],
            ['Kocia Kawiarnia', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta1', 'Wakacyjna Promocja', 'Makowicka', 'hPUL', 'admin'],
            ['Kafcia u Olczaka', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta2', 'Promocja2', 'Makowicka', 'CeH3', 'admin'],
            ['Psia Kawiarnia', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta1', 'Wakacyjna Promocja', 'Rynek', None, 'admin'],
            ['Kafcia u Iwczaka', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta2', 'Promocja2', 'Rynek', None, 'admin'],
            ['Lemingowa Kawiarnia', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta1', 'Wakacyjna Promocja', 'Makowicka', None, 'admin'],
            ['Kafcia u Ewelinczaka', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta2', 'Promocja2', 'Rynek', None, 'admin'],
        ]
        print("Creating Places")
        for place in places:
            print('Create {0}'.format(place[0]))
            offer = Offer.objects.filter(name=place[5])[0]
            promotion_set = PromotionSet.objects.filter(name=place[6])[0]
            localization = Localization.objects.filter(road=place[7])[0]
            if place[8]:
                beacon = Beacon.objects.filter(name=place[8])[0]
            else:
                beacon = None
            owners = User.objects.filter(username=place[9])
            new_place = Place.objects.create(name=place[0], type=place[1], screen_img=place[2], logo_img=place[3],
                                             description=place[4], offer=offer,
                                             localization=localization, beacon=beacon)
            new_place.owners = owners
            new_place.promotion.add(promotion_set)
            new_place.save()
