import django_filters

# Create your views here.
from rest_framework import viewsets, permissions, filters

from App.promotion.models import UserPromotion, UserTask, Promotion, PromotionSet, Task
from App.promotion.serializers import UserTaskSerializer, UserPromotionSerializer, PromotionSerializer, \
    PromotionSetSerializer, TaskSerializer


class UserPromotionFilter(filters.FilterSet):
    place = django_filters.CharFilter(name="place__id")

    class Meta:
        model = UserPromotion
        fields = ['place']


class UserPromotionViewSet(viewsets.ModelViewSet):
    queryset = UserPromotion.objects.all()
    serializer_class = UserPromotionSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)
    filter_backends = (filters.DjangoFilterBackend,)
    filter_class = UserPromotionFilter

    def get_queryset(self):
        user = self.request.user
        return UserPromotion.objects.filter(user=user)


class UserTaskViewSet(viewsets.ModelViewSet):
    queryset = UserTask.objects.all()
    serializer_class = UserTaskSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)
    filter_backends = (filters.DjangoFilterBackend,)

    def get_queryset(self):
        user = self.request.user
        return UserTask.objects.filter(user=user)


class PromotionViewSet(viewsets.ModelViewSet):
    queryset = Promotion.objects.all()
    serializer_class = PromotionSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)


class PromotionSetViewSet(viewsets.ModelViewSet):
    queryset = PromotionSet.objects.all()
    serializer_class = PromotionSetSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)


class TaskViewSet(viewsets.ModelViewSet):
    queryset = Task.objects.all()
    serializer_class = TaskSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)
