from django.db import models


# Create your models here.



class Product(models.Model):
    name = models.CharField(max_length=50)
    description = models.CharField(max_length=50)
    price = models.CharField(max_length=50)
    img = models.ImageField()


class Offer(models.Model):
    name = models.CharField(max_length=50)
    products = models.ManyToManyField(Product)


class Localization(models.Model):
    latitude = models.CharField(max_length=50, )
    longitude = models.CharField(max_length=50, )
    city = models.CharField(max_length=50, )
    road = models.CharField(max_length=50, )
    road_number = models.CharField(max_length=50, )


class Beacon(models.Model):
    uuid = models.CharField(max_length=300, unique=True)
    major = models.CharField(max_length=300, unique=True)
    minor = models.CharField(max_length=300, unique=True)
    name = models.CharField(max_length=300)
    description = models.CharField(max_length=300, null=True)


class Place(models.Model):
    name = models.CharField(max_length=50, unique=True)
    type = models.CharField(max_length=50, )
    screen_img = models.ImageField()
    logo_img = models.ImageField()
    description = models.CharField(max_length=50)
    offer = models.ForeignKey(Offer, null=True, blank=True)
    promotion = models.ForeignKey('promotion.PromotionSet', null=True, blank=True)
    localization = models.ForeignKey(Localization, null=True, blank=True)
    beacon = models.ForeignKey(Beacon, null=True, blank=True)
