"""KawowyDzienniczek URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from django.conf.urls import url, include
from django.contrib import admin
from rest_framework import routers

from App.loyaltyMe import views as loyalty_views
from App.page.views import CommingSoonView, MainPageView, LoginView, LogoutView, PanelPageView, PlacePageListView, \
    PlacePageDetailView, PlaceCreateView, PlaceUpdateView, BeaconPageListView, BeaconCreateView, BeaconUpdateView, \
    BeaconPageDetailView, UserPageDetailView, PromotionSetPageDetailView, PromotionPageDetailView, \
    PromotionSetCreateView, PromotionCreateView, PromotionDeleteView
from App.user import views as user_views
from App.promotion import views as promotion_views
from App.user.views import schema_view

router = routers.DefaultRouter()
router.register(r'user', user_views.UserViewSet)
router.register(r'user_profile', user_views.UserProfileViewSet)
router.register(r'user_promotions', promotion_views.UserPromotionViewSet)
router.register(r'user_tasks', promotion_views.UserTaskViewSet)
router.register(r'products', loyalty_views.ProductViewSet)
router.register(r'offers', loyalty_views.OfferViewSet)
router.register(r'promotions', promotion_views.PromotionViewSet)
router.register(r'promotion_set', promotion_views.PromotionSetViewSet)
router.register(r'places', loyalty_views.PlaceViewSet)
router.register(r'localizations', loyalty_views.LocalizationViewSet)
router.register(r'beacons', loyalty_views.BeaconViewSet)
router.register(r'tasks', promotion_views.TaskViewSet)

urlpatterns = [
    url(r'^api/', include(router.urls)),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^$', CommingSoonView.as_view(), name='cooming_soon'),
    url(r'^main/$', MainPageView.as_view(), name='main_page'),
    url(r'^panel/$', PanelPageView.as_view(), name='main_page'),
    url(r'^login/$', LoginView.as_view(), name='login'),
    url(r'^logout/$', LogoutView.as_view(), name='logout'),
    url(r'^user/(?P<pk>\d+)/$', UserPageDetailView.as_view(), name='user_detail'),
    url(r'^promotion_set/(?P<pk>\d+)/$', PromotionSetPageDetailView.as_view(), name='promotion_set_detail'),
    url(r'^promotion_set/(?P<pk>\d+)/promotion/add$', PromotionCreateView.as_view(), name='promotion_create'),
    url(r'^place/(?P<pk>\d+)/promotion_set/add$', PromotionSetCreateView.as_view(), name='promotion_set_create'),
    url(r'^promotion/(?P<pk>\d+)/$', PromotionPageDetailView.as_view(), name='promotion_detail'),
    url(r'^promotion/(?P<pk>\d+)/delete$', PromotionDeleteView.as_view(), name='promotion_delete'),
    url(r'^place/$', PlacePageListView.as_view(), name='place_list'),
    url(r'^place/add$', PlaceCreateView.as_view(), name='place_add'),
    url(r'^place/(?P<pk>\d+)/update$', PlaceUpdateView.as_view(), name='place_update'),
    url(r'^place/(?P<pk>\d+)/$', PlacePageDetailView.as_view(), name='place_detail'),
    url(r'^beacon/$', BeaconPageListView.as_view(), name='beacon_list'),
    url(r'^beacon/add$', BeaconCreateView.as_view(), name='beacon_add'),
    url(r'^beacon/(?P<pk>\d+)/update$', BeaconUpdateView.as_view(), name='beacon_update'),
    url(r'^beacon/(?P<pk>\d+)/$', BeaconPageDetailView.as_view(), name='beacon_detail'),
    url(r'^api-auth/', include('rest_framework.urls', namespace='rest_framework')),
    url(r'^api-token-auth/', user_views.obtain_auth_token),
    url(r'^docs/', schema_view),
]
