from django.db import models


# Create your models here.


class Product(models.Model):
    name = models.CharField(max_length=50)
    description = models.CharField(max_length=50)
    price = models.CharField(max_length=50)
    img = models.ImageField()


class Offer(models.Model):
    name = models.CharField(max_length=50)
    products = models.ManyToManyField(Product)


class Promotion(models.Model):
    name = models.CharField(max_length=50)
    description = models.CharField(max_length=50)
    code = models.CharField(max_length=50)
    img = models.ImageField()
    status = models.CharField(max_length=50)


class Place(models.Model):
    name = models.CharField(max_length=50, unique=True)
    type = models.CharField(max_length=50,)
    screen_img = models.ImageField()
    logo_img = models.ImageField()
    description = models.CharField(max_length=50)
    offer = models.ForeignKey(Offer, null=True, blank=True)
    promotions = models.ManyToManyField(Promotion, default='')
