from datetime import timedelta, datetime

from django.contrib.auth.models import User
from django.db import models
from django.db.models.signals import post_save
from django.dispatch import receiver
from rest_framework.authtoken.models import Token
from django.test import TestCase
# Create your models here.
from App.loyaltyMe.models import Place, Promotion, Task


@receiver(post_save, sender=User)
def create_auth_token(sender, instance=None, created=False, **kwargs):
    if created:
        Token.objects.create(user=instance)


class UserProfile(models.Model):
    user = models.ForeignKey(User, related_name='user_profile',
                             blank=False, null=False, default=None)
    photo = models.ImageField()


class UserPromotion(models.Model):
    user = models.ForeignKey(User, related_name='user_promotion',
                             blank=False, null=False, default=None)
    place = models.ForeignKey(Place)
    promotion = models.ForeignKey(Promotion)
    status = models.CharField(max_length=30)
    code = models.CharField(max_length=20, null=True)



class UserTask(models.Model):
    task = models.ForeignKey(Task)
    user = models.ForeignKey(User, related_name='user_task',
                             blank=False, null=False, default=None)
    done = models.BooleanField(default=False)
    last_update = models.DateField()
    counter = models.IntegerField()  #akutalnie bylem 3 razy # aktualny status uzytkwonika w zadaniu
    beacon_counter = models.IntegerField()  #  juz 10 minut, jeszcze raz i bedzie hyvka # status czy zaliczyc z beaconow taska
    beacon_signal_last_update = models.DateField()  #ostatnio 23 h temu # last update

    def update(self):
        if not self.ready_to_update():
            return False
        if self.done:
            return False
        if self.task_delay_passed():
            self.counter += self.task.counter_incrementation
        if self.counter == self.task.counter_target:
            self.done = True
            return True
        return False

    def ready_to_update(self):
        if self.beacon_delay_passed():
            self.beacon_counter = +1
            self.beacon_signal_last_update = datetime.now()
        if self.beacon_counter == self.task.beacon_counter_target:
            self.beacon_counter = 0
            return True
        return False

    def beacon_delay_passed(self):
        return self.delay_passed(self.beacon_signal_last_update, self.task.beacon_signal_delay)

    def task_delay_passed(self):
        return self.delay_passed(self.last_update, self.task.update_delay)

    def delay_passed(self, last_update, signal_delay):
        actual_time = datetime.now()
        time_difference = actual_time - last_update
        return time_difference > signal_delay