from django.contrib.auth.models import User
from django.db.models import Q

from App.loyaltyMe.models import Place, Promotion, Task
from App.user.models import UserPromotion, UserTask

from django.core.management.base import BaseCommand


class Command(BaseCommand):
    help = 'Closes the specified poll for voting'

    def handle(self, *args, **options):
        user_promotions = [
            # user = models.ForeignKey(User, related_name='user_promotion',
            #                              blank=False, null=False, default=None)
            # place = models.ForeignKey(Place)
            # promotion = models.ForeignKey(Promotion)
            # status = models.CharField(max_length=30)
            # code = models.CharField(max_length=20)
            ['Klaudia', 'Kocia Kawiarnia', '10%', 'US', 'abcd', 'Bądź u nas 10 godzin'],
            ['Klaudia', 'Kafcia u Olczaka', '20%', 'AC', 'abcd', 'Przyjdz 10 razy'],
            ['Antek', 'Kafcia u Olczaka', '50%', 'AC', 'abcd', 'Bądź u nas 10 godzin'],
            ['admin', 'Kafcia u Olczaka', '10%', 'AC', 'abcd', 'Przyjdz 10 razy'],
        ]
        print("Creating UserPromotions")
        for user_promotion in user_promotions:
            print('Create {0} UserPromotion'.format(user_promotion[0]))
            user = User.objects.filter(username=user_promotion[0])[0]
            place = Place.objects.filter(name=user_promotion[1])[0]
            promotion = Promotion.objects.filter(name=user_promotion[2])[0]
            task = Task.objects.filter(name=user_promotion[5])[0]
            user_task = UserTask.objects.filter(Q(task=task), Q(user=user))[0]
            new_user_promotion = UserPromotion.objects.create(user=user, place=place, promotion=promotion,
                                                              progress=user_promotion[3], code=user_promotion[4],
                                                              user_task=user_task)
            new_user_promotion.save()
