# Create your tests here.
from datetime import timedelta

from django.contrib.auth.models import User
from django.test import TestCase
from django.utils import timezone

from App.loyaltyMe.models import Task
from App.user.models import UserTask


class TaskTestCase(TestCase):
    def setUp(self):
        self.task = Task.objects.get_or_create(type="TM", update_delay=timedelta(seconds=10),
                                               description="Test_description", name="test_name", counter_target=1,
                                               beacon_counter_target=2, counter_incrementation=1,
                                               beacon_signal_delay=timedelta(seconds=15),
                                               beacon_singal_delay_maximum_delay=timedelta(seconds=300))[0]

    def test_pass(self):
        pass


class UserTaskTestCase(TestCase):
    def setUp(self):
        self.user = User.objects.get_or_create()[0]
        self.task = Task.objects.get_or_create(type="TM", update_delay=timedelta(seconds=10),
                                               description="Test_description", name="test_name", counter_target=1,
                                               beacon_counter_target=2, counter_incrementation=1,
                                               beacon_signal_delay=timedelta(seconds=15),
                                               beacon_singal_delay_maximum_delay=timedelta(seconds=300))[0]
        self.task.save()
        beacon_signal_last_update = timezone.now() - timedelta(seconds=15)
        self.user_task = UserTask.objects.get_or_create(task=self.task, user=self.user, done=False,
                                                        last_update=timezone.now(),
                                                        counter=0, beacon_counter=0,
                                                        beacon_signal_last_update=beacon_signal_last_update)[0]
        self.user_task.save()

    def set_data_beacon_singal_passed(self):
        self.user_task.task.beacon_signal_delay = timedelta(seconds=15)
        self.user_task.beacon_signal_last_update = timezone.now() - timedelta(seconds=15)

    def set_data_task_signal_passed(self):
        self.user_task.update_delay = timedelta(seconds=15)
        self.user_task.last_update = timezone.now() - timedelta(seconds=20)

    def set_data_maximum_beacon_singal_passed(self):
        self.user_task.task.beacon_signal_delay = timedelta(seconds=15)
        self.task.beacon_singal_delay_maximum_delay = timedelta(seconds=300)
        self.user_task.beacon_signal_last_update = timezone.now() - timedelta(seconds=305)

    def test_maximum_delay_passed(self):
        self.set_data_maximum_beacon_singal_passed()
        self.assertFalse(self.user_task.ready_to_update())

    def test_delay_passed(self):
        signal_last_update = timezone.now() - timedelta(seconds=16)
        signal_delay = timedelta(seconds=15)
        result = self.user_task.delay_passed(signal_last_update, signal_delay)
        self.assertTrue(result)

    def test_delay_passed_limit_value(self):
        signal_last_update = timedelta(seconds=15)
        signal_delay = timezone.now() - timedelta(seconds=15)
        result = self.user_task.delay_passed(signal_last_update, signal_delay)
        self.assertTrue(result)

    def test_delay_not_passed(self):
        signal_last_update = timedelta(seconds=15)
        signal_delay = timezone.now() - timedelta(seconds=14)
        result = self.user_task.delay_passed(signal_last_update, signal_delay)
        self.assertFalse(result)

    def test_ready_to_update_beacon_counter_increase(self):
        self.set_data_beacon_singal_passed()
        self.user_task.beacon_counter = 0
        result = self.user_task.ready_to_update()
        self.assertEqual(self.user_task.beacon_counter, 1)
        self.assertFalse(result)

    def test_ready_to_update_beacon_counter_not_increase(self):
        self.user_task.task.beacon_signal_delay = timedelta(seconds=15)
        self.user_task.beacon_signal_last_update = timezone.now() - timedelta(seconds=14)
        self.user_task.beacon_counter = 0
        self.user_task.task.beacon_counter_target = 2
        result = self.user_task.ready_to_update()
        self.assertEqual(self.user_task.beacon_counter, 0)
        self.assertFalse(result)

    def test_ready_to_update_beacon_counter_reset(self):
        self.set_data_beacon_singal_passed()
        self.user_task.beacon_counter = 0
        self.user_task.task.beacon_counter_target = 1
        result = self.user_task.ready_to_update()
        self.assertEqual(self.user_task.beacon_counter, 0)
        self.assertTrue(result)

    def test_update_counter_increase(self):
        self.set_data_task_signal_passed()
        self.set_data_beacon_singal_passed()
        self.user_task.beacon_counter = 0
        self.user_task.task.beacon_counter_target = 1
        self.user_task.counter = 0
        self.user_task.task.counter_target = 2
        result = self.user_task.update()
        self.assertEqual(self.user_task.counter, 1)
        self.assertFalse(result)

    def test_update_counter_not_increase(self):
        self.set_data_beacon_singal_passed()

        self.user_task.update_delay = timedelta(seconds=15)
        self.user_task.last_update = timezone.now()

        self.user_task.beacon_counter = 0
        self.user_task.task.beacon_counter_target = 1
        self.user_task.counter = 0
        self.user_task.task.counter_target = 2

        result = self.user_task.update()
        self.assertEqual(self.user_task.counter, 0)
        self.assertFalse(result)

    def test_update_task_done(self):
        self.set_data_task_signal_passed()
        self.set_data_beacon_singal_passed()
        self.user_task.beacon_counter = 0
        self.user_task.task.beacon_counter_target = 1

        self.user_task.counter = 0
        self.user_task.task.counter_target = 1

        result = self.user_task.update()
        self.assertTrue(self.user_task.done)
        self.assertTrue(result)

    def test_update_test_not_ready_to_update(self):
        self.user_task.signal_last_update = timedelta(seconds=15)
        self.user_task.signal_delay = timezone.now() - timedelta(seconds=14)
        result = self.user_task.update()
        self.assertFalse(result)

    def test_update_test_task_is_done(self):
        self.set_data_task_signal_passed()
        self.set_data_beacon_singal_passed()
        self.user_task.beacon_counter = 0
        self.user_task.task.beacon_counter_target = 1

        self.user_task.counter = 0
        self.user_task.task.counter_target = 1
        self.user_task.done = True

        result = self.user_task.update()
        self.assertFalse(result)
