from django.core.management.base import BaseCommand

from App.loyaltyMe.models import Place, Offer, PromotionSet, Localization, Beacon


class Command(BaseCommand):
    help = 'Closes the specified poll for voting'

    def handle(self, *args, **options):
        places = [
            # ['name', 'type', 'screen_img', 'logo_img', 'description', 'offer', 'promotions'],
            ['Kocia Kawiarnia', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta1', 'Promocja1', 'Makowicka', 'hPUL'],
            ['Kafcia u Olczaka', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta2', 'Promocja2', 'Makowicka', 'CeH3'],
            ['Psia Kawiarnia', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta1', 'Promocja1', 'Rynek', None],
            ['Kafcia u Iwczaka', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta2', 'Promocja2', 'Rynek', None],
            ['Lemingowa Kawiarnia', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta1', 'Promocja1', 'Makowicka', None],
            ['Kafcia u Ewelinczaka', 'Cafeteria', '/static/img/photo_1.jpg', '/static/img/photo_1.jpg', 'description',
             'Oferta2', 'Promocja2', 'Rynek', None],
        ]
        print("Creating Places")
        for place in places:
            print('Create {0}'.format(place[0]))
            offer = Offer.objects.filter(name=place[5])[0]
            promotion_set = PromotionSet.objects.filter(name=place[6])[0]
            localization = Localization.objects.filter(road=place[7])[0]
            if place[8]:
                beacon = Beacon.objects.filter(name=place[8])[0]
            else:
                beacon = None
            new_place = Place.objects.create(name=place[0], type=place[1], screen_img=place[2], logo_img=place[3],
                                             description=place[4], offer=offer, promotion=promotion_set,
                                             localization=localization, beacon=beacon)
            new_place.save()
