package anotherlineofcode.com.jointhecityapp;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import com.nostra13.universalimageloader.core.ImageLoader;

import java.util.ArrayList;


public class ApiListAdapter extends ArrayAdapter<ApiObject> {
    public ApiListAdapter(Context context, ArrayList<ApiObject> users) {
        super(context, 0, users);
    }

    @Override
    public View getView(final int position, View convertView, final ViewGroup parent) {
        // Get the data item for this position
        ApiObject api = getItem(position);
        // Check if an existing view is being reused, otherwise inflate the view
        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(R.layout.api_item, parent, false);
        }
        // Lookup view for data population
        ImageView picture = (ImageView) convertView.findViewById(R.id.photo);
        TextView name = (TextView) convertView.findViewById(R.id.name);
        TextView description = (TextView) convertView.findViewById(R.id.description);
        Button startUsing = (Button) convertView.findViewById(R.id.start);

        // Populate the data into the template view using the data object
        ImageLoader.getInstance().displayImage(api.getImageUrl(), picture);
        name.setText(api.getName());
        description.setText(api.getDescription());

        startUsing.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ((ListView)parent).performItemClick(v, position, 0);
            }
        });

        // Return the completed view to render on screen
        return convertView;
    }
}
