from django.core.files import File
from app.API.models import API, APIType
from app.Tag.models import Tag

__author__ = 'Rafal'
from django.core.management.base import BaseCommand


class Command(BaseCommand):
    help = 'Closes the specified poll for voting'

    def handle(self, *args, **options):
        apis = [
            ['Apteki w Krakowie', 'Krakow', 'map', 'apteki', 'image/pharmacy.png', 'Wspolrzedne Aptek w miescie Krakow'],
            ['Baseny w Krakowie', 'Krakow', 'map', 'baseny', 'image/swimming.png', 'Wspolrzedne Basenow w miescie Krakow'],
            ['Hotele w Krakowie', 'Krakow', 'map','hotele', 'image/hotel.png', 'Wspolrzedne Hoteli w miescie Krakow'],
            #['HotSpoty w Krakowie', 'Krakow', 'map','mapaHotSpotow', 'image/icon.jpg', 'Opis API o aptekach w Krakowie'],
            ['Utrudnienia w Krakowie', 'Krakow', 'map','mapaUtrudnien', 'image/wrong.png', 'Mapa z utrudnieniami w Krakowie'],
            ['Restauracje w Krakowie', 'Krakow', 'map','restauracje', 'image/restaurant.png', 'Mapa z restauracjami w Krakowie'],
            ['Szpitale w Krakowie', 'Krakow', 'map','szpitale', 'image/hospital.png', 'Mapa z szpitalami w Krakowie'],
            ['Zdarzenia drogowe w Krakowie', 'Krakow', 'map','zdarzeniaDrogowe', 'image/car_crash.png', 'Mapa z zdarzeniami drogowymi w Krakowie'],
            ]
        print "Creating APIs"
        for api in apis:
            print "Create {0}".format(api[0])
            tag = Tag.objects.filter(name=api[1])[0]
            api_type = APIType.objects.filter(name=api[2])[0]
            new_api = API.objects.create(name=api[0], type=api_type, source=api[3] , description = api[5])
            new_api.tag = [tag, ]
            new_api.icon = api[4]
            new_api.save()