from django.contrib.auth.models import User
from django.db import models
from app.Tag.models import Tag
from django.utils.datetime_safe import datetime


class TextMessage(models.Model):
    user = models.ForeignKey(User, related_name='user_creator_of_message',
                             blank=False, null=False, default=None)
    text = models.CharField(max_length=1000)
    created_at = models.DateTimeField(default=datetime.now)

    def __str__(self):
        return self.text

class Discussion(models.Model):
    user = models.ForeignKey(User, related_name='user_creator_of_discussion',
                             blank=False, null=False, default=None)
    question = models.CharField(max_length=100)
    message = models.ManyToManyField(TextMessage, blank=True, null=True, related_name="conversations_participant")
    tag = models.ForeignKey(Tag, related_name='place_of_discussion', blank=False, null=False, default=None)

    def __str__(self):
        return self.question