import json
from app.API.serializers import APISerializer
from lib.api.API import BaseAPI

__author__ = 'Dominik Rosiek'

class API(BaseAPI):
    resource = "b9349f75-c0e5-47a7-99a2-2f1ec4f32ad6"
    site = "https://api.bihapi.pl/dane/krakow"
    methods = ('default', 'object')

    def default(self):
        return json.dumps(self.GET(parameters=self.request.GET.dict()))

    def object(self):
        data = self.GET(parameters=self.request.GET.dict())
        results = []
        try:
            for obj in data['results']:
                results.append(self.unpack(obj))
        except TypeError as e:
            results.append(self.unpack(data['results']))
        return json.dumps(results)

    def unpack(self, obj):
        result = {}
        for property in obj['properties']:
            if property['key'] == 'date':
                result['date'] = property['value']
            elif property['key'] == 'street1':
                result['street1'] = property['value']
            elif property['key'] == 'street2':
                result['street2'] = property['value']
            elif property['key'] == 'street3':
                result['street3'] = property['value']
            elif property['key'] == 'geometry':
                result['geometry'] = property['value']
            elif property['key'] == 'light':
                result['light'] = property['value']
            elif property['key'] == 'type':
                result['type'] = property['value']
            elif property['key'] == 'maxspeed':
                result['maxspeed'] = property['value']
            elif property['key'] == 'sprawca':
                result['sprawca'] = property['value']
        return result