package anotherlineofcode.com.jointhecityapp;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.nostra13.universalimageloader.cache.memory.impl.WeakMemoryCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

import cz.msebera.android.httpclient.Header;


public class MainActivity extends AppCompatActivity {

    public final static int LOGIN_REQUEST = 1;
    private SharedPreferences sharedPreferences;
    private Context context = this;
    private AsyncHttpClient client;
    private RecyclerView rView;
    private RecyclerViewAdapter rcAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getSupportActionBar().setDisplayShowHomeEnabled(true);
        getSupportActionBar().setLogo(R.drawable.logo_bar);
        getSupportActionBar().setDisplayUseLogoEnabled(true);
        getSupportActionBar().setDisplayShowTitleEnabled(false);
        setContentView(R.layout.activity_main);

        DisplayImageOptions defaultOptions = new DisplayImageOptions.Builder().cacheInMemory(true)
                .cacheOnDisc(true).resetViewBeforeLoading(false).build();

        ImageLoaderConfiguration config = new ImageLoaderConfiguration.Builder(
                this.getApplicationContext())
                .defaultDisplayImageOptions(defaultOptions)
                .memoryCache(new WeakMemoryCache())
                .discCacheSize(1024 * 1024).build();

        ImageLoader.getInstance().init(config);

        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent = new Intent(context, AddApiActivity.class);
                startActivity(intent);
            }
        });


        sharedPreferences = getSharedPreferences("JoinTheCityPreferences", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt("lat",50);
        editor.putInt("lng", 19);
        editor.commit();

        // Check if user is logged in, if not open login activity
        if (!isLoggedIn()) {
            Intent intent = new Intent(this, LoginAndRegistrationActivity.class);
            startActivityForResult(intent, LOGIN_REQUEST);
        }

        final GridLayoutManager lLayout = new GridLayoutManager(context, 2);

        rView = (RecyclerView)findViewById(R.id.recycler_view);
        rView.setHasFixedSize(true);
        rView.setLayoutManager(lLayout);


    }

    @Override
    protected void onResume() {
        super.onResume();
        if (rView != null){
            rView.invalidate();
        }
        Globals.usedApi.clear();
        getUsedApiList();
    }

    private void getUsedApiList(){
        client = new AsyncHttpClient();
        client.addHeader("Authorization", "Token " + sharedPreferences.getString("token", ""));

        client.get(getString(R.string.api_url) + "api/user_api/", new AsyncHttpResponseHandler() {

            @Override
            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                client = null;

                // Retrieve server response
                JSONObject jsonResponse = JSONParser.parseObject(responseBody);

                try {
                    for (int i = 0; i < jsonResponse.getInt("count"); i++) {
                        JSONObject api = jsonResponse.getJSONArray("results").getJSONObject(i).getJSONObject("api");
                        Globals.usedApi.add(new ApiObject(api.getInt("id"), api.getString("name"), api.getString("description"), api.getString("icon"), api.getString("url")));
                    }

                    List<ApiObject> rowListItem = Globals.usedApi;

                    rcAdapter = new RecyclerViewAdapter(context, rowListItem);
                    rView.setAdapter(rcAdapter);

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                client = null;

            }
        });

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == LOGIN_REQUEST){
            if (resultCode != RESULT_OK) {
                // Finish activity when user did not sign in/up
                finish();
            }
        }
    }

    private boolean isLoggedIn() {
        return !sharedPreferences.getString("token", "").isEmpty();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();


        return super.onOptionsItemSelected(item);
    }
}
