# Create your views here.
from django.http import HttpResponse, Http404
from rest_framework import viewsets, permissions
import rest_framework
from rest_framework.response import Response
from app.API.models import API, APIType
from app.API.serializers import APISerializer, APITypeSerializer


class APIViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = API.objects.all()
    serializer_class = APISerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    @staticmethod
    def test(request, id, function, slash):
        try:
            object = API.objects.get(pk=id)
        except Exception as e:
            raise Http404

        name = "lib.api.{0}".format(object.name)
        mod = __import__(name, fromlist=['API'])
        api = mod.API(request)
        return HttpResponse(api.execute(function), content_type="application/json")

class APITypeViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = APIType.obejects.all()
    serializer_class = APITypeSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)