# Create your views here.
from django.shortcuts import get_object_or_404
from rest_framework import viewsets, permissions
from rest_framework.decorators import detail_route
from app.API.serializers import APISerializer
from app.Discussion.models import Discussion, TextMessage
from app.Discussion.serializers import TextMessageSerializer, DiscussionSerializer
from rest_framework.response import Response
import rest_framework

class DiscussionViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Discussion.objects.all()
    serializer_class = DiscussionSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    @detail_route(methods=['post'],  permission_classes=[permissions.AllowAny])
    def add(self, request, pk=None):
        discussion = get_object_or_404(self.queryset, pk=pk)
        text = request.data.get('text')
        print "XD"
        print request.__dict__
        user = request.user
        discussion.add_message(text=text, user=user)
        return Response(status=rest_framework.status.HTTP_200_OK)

class TextMessageViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = TextMessage.objects.all()
    serializer_class = TextMessageSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)