import json
from app.API.serializers import APISerializer
from lib.api.API import BaseAPI

__author__ = 'Dominik Rosiek'

class API(BaseAPI):
    resource = "b02b0bb5-1197-4128-9e48-c679e07ba350"
    site = "https://api.bihapi.pl/dane/krakow"
    methods = ('default', 'object')

    def default(self):
        return self.GET(parameters=self.request.GET.dict())

    def object(self):
        data = self.GET(parameters=self.request.GET.dict())
        results = []
        try:
            for obj in data['results']:
                results.append(self.unpack(obj))
        except TypeError as e:
            results.append(self.unpack(data['results']))
        return results

    def unpack(self, obj):
        result = {}
        for property in obj['properties']:
            if property['key'] == 'HOTEL_NAZWA':
                result['name'] = property['value']
            elif property['key'] == 'OADR_GPS_S':
                result['latitude'] = property['value']
            elif property['key'] == 'OADR_GPS_D':
                result['longitude'] = property['value']
            elif property['key'] == 'OADR_MIASTO':
                result['city'] = property['value']
            elif property['key'] == 'OADR_ULICA':
                result['street'] = property['value']
            elif property['key'] == 'OADR_NR':
                result['nr'] = property['value']

        result['address'] = "{0} {1}, {2}".format(result['street'].encode("utf-8"), result['nr'].encode("utf-8"), result['city'].encode("utf-8"))
        return result
