from django.contrib.auth.models import User
from django.shortcuts import get_object_or_404
from rest_framework import viewsets, permissions
import rest_framework
from rest_framework.decorators import list_route, detail_route
from rest_framework.response import Response
from app.User.models import UserFriendship, UserAPI, UserEvent, UserEventRequest
from app.User.serializers import UserFriendshipSerializer, UserAPISerializer, \
    UserEventSerializer, UserEventRequestSerializer, UserSerializer


class UserViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = User.objects.all()
    serializer_class = UserSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    @list_route(methods=['get'])
    def me(self, request, pk=None):
        user = User.objects.filter(pk=request.user.id)[0]
        user_data = UserSerializer(user, context={'request': request}).data
        return Response(status=rest_framework.status.HTTP_200_OK, data= user_data)

class UserFriendshipViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = UserFriendship.objects.all()
    serializer_class = UserFriendshipSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def perform_create(self, serializer):
        serializer.save(user=self.request.user)

    def list(self, request):
        user = request.user
        queryset = UserFriendship.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = UserFriendshipSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)


class UserEventRequestViewSet(viewsets.ModelViewSet):
    """
    User Friendships
    """
    queryset = UserEventRequest.objects.all()
    serializer_class = UserEventRequestSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def perform_create(self, serializer):
        serializer.save(user=self.request.user)

    def list(self, request):
        user = request.user
        queryset = UserEventRequest.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = UserEventRequestSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)

    @detail_route()
    def accept(self, request, pk=None):
        event_request = get_object_or_404(self.queryset, pk=pk)
        event_request.accept()
        return Response(status=rest_framework.status.HTTP_200_OK)

    @detail_route()
    def decline(self, request, pk=None):
        event_request = get_object_or_404(self.queryset, pk=pk)
        event_request.delete()
        return Response(status=rest_framework.status.HTTP_200_OK)


class UserAPIViewSet(viewsets.ModelViewSet):
    """
    User favorite api
    """
    queryset = UserAPI.objects.all()
    serializer_class = UserAPISerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def perform_create(self, serializer):
        serializer.save(user=self.request.user)

    def list(self, request):
        user = request.user
        queryset = UserAPI.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = UserAPISerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)

class UserEventViewSet(viewsets.ModelViewSet):
    """
    User participant in this event
    """
    queryset = UserEvent.objects.all()
    serializer_class = UserEventSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def perform_create(self, serializer):
        serializer.save(user=self.request.user)

    def list(self, request):
        user = request.user
        queryset = UserEvent.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = UserEventSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)