from django.db import models


# Create your models here.
from app.Tag.models import Tag



class APIType(models.Model):
    name = models.CharField(max_length=100)

    def __str__(self):
        return self.name

class API(models.Model):
    name = models.CharField(max_length=100)
    tag = models.ManyToManyField(Tag, related_name='API_tags', blank=False, default=None)
    type = models.ForeignKey(APIType, related_name='API_type',
                             blank=False, null=False, default=None)
    source = models.CharField(max_length=100)
    icon = models.ImageField(null=True, blank=True)
    description = models.CharField(max_length=300, default=None, null=True, blank=True)
    data = models.CharField(max_length=100, null=True, default='',blank=True)


    def __str__(self):
        return self.name


