package anotherlineofcode.com.jointhecityapp.discussion_support;

import android.content.Context;
import android.content.Intent;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;

import org.json.JSONException;
import org.json.JSONObject;

import anotherlineofcode.com.jointhecityapp.JSONParser;
import cz.msebera.android.httpclient.Header;

/**
 * Created by adam on 12.01.16.
 */
public class Tag {

    private String mName;
    private String mLocation_link;
    private Float mLatitude;
    private Float mLongitude;

    public Tag(JSONObject jsonObject){
        try {
            mName = (String) jsonObject.get("name");
            mLocation_link =  (String) ((JSONObject)jsonObject).get("localization");
        } catch (JSONException e) {
            e.printStackTrace();
        }

        AsyncHttpClient client = new AsyncHttpClient();

        client.get(mLocation_link, new AsyncHttpResponseHandler() {
            @Override
            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                JSONObject jsonResponse = JSONParser.parseObject(responseBody);

                try {
                    mLongitude = Float.parseFloat((String)jsonResponse.get("longitude"));
                    mLatitude = Float.parseFloat((String) jsonResponse.get("latitude"));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {

            }
        });
    }

    public void startChat(Context context){
        Intent startChat = new Intent(context, ChatActivity.class);
    }

    @Override
    public String toString(){
        return mName;
    }
}
