from django.contrib.auth.models import User
from rest_framework import viewsets, permissions
from app.User.models import UserFriendship, UserFriendshipRequest, UserAPI, UserEvent, UserEventRequest
from app.User.serializers import UserFriendshipSerializer, UserFriendshipRequestSerializer, UserAPISerializer, \
    UserEventSerializer, UserEventRequestSerializer, UserSerializer


class UserViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = User.objects.all()
    serializer_class = UserSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

class UserFriendshipViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = UserFriendship.objects.all()
    serializer_class = UserFriendshipSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request):
        user = request.user
        queryset = UserFriendship.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = UserFriendshipSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)

class UserFriendshipRequestViewSet(viewsets.ModelViewSet):
    """
    User Friendships
    """
    queryset = UserFriendshipRequest.objects.all()
    serializer_class = UserFriendshipRequestSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request):
        user = request.user
        queryset = UserFriendshipRequest.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = UserFriendshipRequestSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)

class UserEventRequestViewSet(viewsets.ModelViewSet):
    """
    User Friendships
    """
    queryset = UserEventRequest.objects.all()
    serializer_class = UserEventRequestSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request):
        user = request.user
        queryset = UserEventRequest.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = UserEventRequestSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)


class UserAPIViewSet(viewsets.ModelViewSet):
    """
    User favorite api
    """
    queryset = UserAPI.objects.all()
    serializer_class = UserAPISerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request):
        user = request.user
        queryset = UserAPI.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = UserAPISerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)

class UserEventViewSet(viewsets.ModelViewSet):
    """
    User participant in this event
    """
    queryset = UserEvent.objects.all()
    serializer_class = UserEventSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request):
        user = request.user
        queryset = UserEvent.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = UserEventSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)