from django.contrib.auth.models import User
from app.Friendship.models import FriendshipRequest
from app.User.models import UserFriendship

__author__ = 'Rafal'
from django.core.management.base import BaseCommand, CommandError

class Command(BaseCommand):
    help = 'Closes the specified poll for voting'

    def add_arguments(self, parser):
        parser.add_argument('poll_id', nargs='+', type=int)

    def handle(self, *args, **options):
        users = [
            'admin', 'Antek', 'Rafal', 'Klaudia'
            ]

        admin = User.objects.filter(username=users[0])[0]
        Antek = User.objects.filter(username=users[1])[0]
        Rafal = User.objects.filter(username=users[2])[0]
        Klaudia = User.objects.filter(username=users[3])[0]

        print "Create friendships"
        print "admin is friend with Antek"
        friendship = UserFriendship.objects.create(user=admin, friend=Antek)
        friendship.save()
        print "admin is friend with Rafal"
        friendship = UserFriendship.objects.create(user=admin, friend=Rafal)
        friendship.save()
        print "Rafal is friend with Klaudia"
        friendship = UserFriendship.objects.create(user=Rafal, friend=Klaudia)
        friendship.save()

        print "Create friendships_requests"
        print "Admin send FriendRequest to Klaudia"
        new_friendshiprequest = FriendshipRequest.objects.create(user=admin, created_by=Klaudia)
        new_friendshiprequest.save()
        print "Klaudia send FriendRequest to Antek"
        new_friendshiprequest= FriendshipRequest.objects.create(user=Klaudia, created_by=Antek)
        new_friendshiprequest.save()

