# Create your views here.
from rest_framework import viewsets, permissions
from app.API.serializers import APISerializer
from app.Discussion.models import Discussion, TextMessage
from app.Discussion.serializers import TextMessageSerializer, DiscussionSerializer


class DiscussionViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Discussion.objects.all()
    serializer_class = DiscussionSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

class TextMessageViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = TextMessage.objects.all()
    serializer_class = TextMessageSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)