package anotherlineofcode.com.jointhecityapp;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.support.v4.app.FragmentActivity;
import android.os.Bundle;
import android.util.Log;

import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MarkerOptions;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.JsonHttpResponseHandler;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import cn.pedant.SweetAlert.SweetAlertDialog;
import cz.msebera.android.httpclient.Header;

public class MapsActivity extends FragmentActivity implements OnMapReadyCallback {

    private GoogleMap mMap;
    private SharedPreferences sharedPreferences;
    private AsyncHttpClient client;
    private final Context context = this;
    private String url;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_maps);

        sharedPreferences = getSharedPreferences("JoinTheCityPreferences", Context.MODE_PRIVATE);

        url = getIntent().getExtras().getString("url");

        Log.d("url", url);

        // Obtain the SupportMapFragment and get notified when the map is ready to be used.
        SupportMapFragment mapFragment = (SupportMapFragment) getSupportFragmentManager()
                .findFragmentById(R.id.map);
        mapFragment.getMap().moveCamera(CameraUpdateFactory.newLatLngZoom(new LatLng(52.0, 20.0), 5.0f));
        mapFragment.getMapAsync(this);
    }


    /**
     * Manipulates the map once available.
     * This callback is triggered when the map is ready to be used.
     * This is where we can add markers or lines, add listeners or move the camera. In this case,
     * we just add a marker near Sydney, Australia.
     * If Google Play services is not installed on the device, the user will be prompted to install
     * it inside the SupportMapFragment. This method will only be triggered once the user has
     * installed Google Play services and returned to the app.
     */
    @Override
    public void onMapReady(GoogleMap googleMap) {
        mMap = googleMap;

        client = new AsyncHttpClient();
        client.addHeader("Authorization", "Token " + sharedPreferences.getString("token", ""));


        Log.d("URL KURWA", url + "?method=object");

        client.get(url + "?method=object", new AsyncHttpResponseHandler() {
            @Override
            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                client = null;
                displayMarkers();
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {

            }
        });



    }

    public void displayMarkers(){
        client = new AsyncHttpClient();
        client.addHeader("Authorization", "Token " + sharedPreferences.getString("token", ""));

        // Display progress bar
        final SweetAlertDialog pDialog = new SweetAlertDialog(this, SweetAlertDialog.PROGRESS_TYPE);
        pDialog.getProgressHelper().setBarColor(Color.parseColor("#9FC967"));
        pDialog.setTitleText("Pobieranie danych...");
        pDialog.setCancelable(false);
        pDialog.show();

        client.get(url + "parssed/?format=json", new JsonHttpResponseHandler() {

            @Override
            public void onSuccess(int statusCode, Header[] headers, JSONArray response) {
                super.onSuccess(statusCode, headers, response);

                client = null;
                pDialog.dismiss();


                try {
                    Log.d("UPRARSED", response.toString());
                    for (int i=0; i<response.length(); i++){
                        Log.d("Data", response.toString());
                        JSONObject object = response.getJSONObject(i);
                        Log.d("Object", object.toString());
                        LatLng camera = new LatLng(object.getDouble("latitude"), object.getDouble("longitude"));

                        // Add a marker in Sydney and move the camera
                        mMap.addMarker(new MarkerOptions().position(camera).title(object.getString("name")).snippet(object.getString("address")));
                    }

                    //Move the camera to the user's location and zoom in!
                    mMap.animateCamera(CameraUpdateFactory.newLatLngZoom(new LatLng(50.0646501, 19.9449799), 11.0f));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, String responseString, Throwable throwable) {
                super.onFailure(statusCode, headers, responseString, throwable);

                client = null;
                pDialog.dismiss();

                // Display error dialog
                new SweetAlertDialog(context, SweetAlertDialog.ERROR_TYPE)
                        .setTitleText("Błąd")
                        .setContentText(responseString)
                        .show();

                Log.e("ERROR", responseString);
            }




        });
    }
}
