package anotherlineofcode.com.jointhecityapp;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

import cn.pedant.SweetAlert.SweetAlertDialog;
import cz.msebera.android.httpclient.Header;

public class AddApiActivity extends AppCompatActivity {

    private AsyncHttpClient client;
    private SharedPreferences sharedPreferences;
    private Context context = this;
    private ArrayList<ApiObject> apiList;
    private ListView listView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_add_api);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        listView = (ListView) findViewById(R.id.listview_api);
        sharedPreferences = getSharedPreferences("JoinTheCityPreferences", Context.MODE_PRIVATE);

        downloadApiList();
        displayApiList();

        AdapterView.OnItemClickListener itemClickListener = new AdapterView.OnItemClickListener(){
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                ApiObject selected = (ApiObject) parent.getItemAtPosition(position);

                saveApi(selected.getUrl());
                Log.d("SELECT", selected.getUrl());
            }
        };
        listView.setOnItemClickListener(itemClickListener);

    }

    private void saveApi(String url){
        client = new AsyncHttpClient();
        client.addHeader("Authorization", "Token " + sharedPreferences.getString("token", ""));

        Log.d("URL", url + "add/");

        // Display progress bar
        final SweetAlertDialog pDialog = new SweetAlertDialog(this, SweetAlertDialog.PROGRESS_TYPE);
        pDialog.getProgressHelper().setBarColor(Color.parseColor("#9FC967"));
        pDialog.setTitleText("Zapisywanie danych...");
        pDialog.setCancelable(false);
        pDialog.show();

        client.get(url + "add/", new AsyncHttpResponseHandler() {

            @Override
            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                client = null;
                pDialog.dismiss();

                // Display success dialog
                SweetAlertDialog sDialog = new SweetAlertDialog(context, SweetAlertDialog.SUCCESS_TYPE)
                        .setTitleText("Dodano API!")
                        .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                            @Override
                            public void onClick(SweetAlertDialog sDialog) {
                                sDialog.dismissWithAnimation();

                                // Finish activity
                                finish();
                            }
                        });
                sDialog.setCancelable(false);
                sDialog.show();
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                client = null;
                pDialog.dismiss();

                // Display error dialog
                new SweetAlertDialog(context, SweetAlertDialog.ERROR_TYPE)
                        .setTitleText("Błąd")
                        .setContentText(error.toString())
                        .show();

                Log.e("ERROR", error.toString());
            }
        });
    }

    private void downloadApiList(){
        client = new AsyncHttpClient();

        // Display progress bar
        final SweetAlertDialog pDialog = new SweetAlertDialog(this, SweetAlertDialog.PROGRESS_TYPE);
        pDialog.getProgressHelper().setBarColor(Color.parseColor("#9FC967"));
        pDialog.setTitleText("Pobieranie danych...");
        pDialog.setCancelable(false);
        pDialog.show();

        client.get(getString(R.string.api_url) + "api/api/?only_new=True", new AsyncHttpResponseHandler() {

            @Override
            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                client = null;
                pDialog.dismiss();

                // Retrieve server response
                JSONObject jsonResponse = JSONParser.parseObject(responseBody);
                try {
                    apiList = new ArrayList<>();
                    for (int i = 0; i < jsonResponse.getInt("count"); i++) {
                        JSONObject api = jsonResponse.getJSONArray("results").getJSONObject(i);
                        apiList.add(new ApiObject(api.getInt("id"), api.getString("name"), api.getString("description"), api.getString("icon"), api.getString("url")));
                    }

                    listView.setAdapter(new ApiListAdapter(context, apiList));


                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }

            @Override
            public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                client = null;
                pDialog.dismiss();

                // Display error dialog
                new SweetAlertDialog(context, SweetAlertDialog.ERROR_TYPE)
                        .setTitleText("Błąd")
                        .setContentText(error.toString())
                        .show();
            }
        });
    }

    public void displayApiList(){

    }

}
