from django.contrib.auth.models import User
from django.db import models

# Create your models here.
from django.db.models.signals import post_save
from django.dispatch import receiver
from rest_framework.authtoken.models import Token
from JoinTheCityREST import settings
from app.API.models import API
from app.Event.models import Event


class UserFriendship(models.Model):
    user = models.ForeignKey(User, related_name='user_friendship',
                             blank=False, null=False, default=None)
    friend = models.ForeignKey(User, related_name='user_friend',
                               blank=False, null=False, default=None)

class UserAPI(models.Model):
    user = models.ForeignKey(User, related_name='api_participant',
                             blank=False, null=False, default=None)
    api = models.ForeignKey(API, related_name='api_choosen_by_user',
                            blank=False, null=False, default=None)

class UserEvent(models.Model):
    user = models.ForeignKey(User, related_name='event_participant',
                             blank=False, null=False, default=None)
    event = models.ForeignKey(Event, related_name='event_choosen_by_user',
                              blank=False, null=False, default=None)

class UserEventRequest(models.Model):
    user = models.ForeignKey(User, related_name='user_event_request_recived',
                             blank=False, null=False, default=None)
    created_by = models.ForeignKey(User, related_name='user_event_requeset_creator',
                                   blank=False, null=False, default=None)
    event = models.ForeignKey(Event, related_name='event',
                              blank=False, null=False, default=None)

    def accept(self):
        user_event = UserEvent(user=self.user, event=self.event)
        user_event.save()
        self.delete()

@receiver(post_save, sender=User)
def create_auth_token(sender, instance=None, created=False, **kwargs):
    if created:
        Token.objects.create(user=instance)