package anotherlineofcode.com.jointhecityapp.discussion_support;

import android.app.Activity;
import android.content.Intent;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import java.util.List;

import anotherlineofcode.com.jointhecityapp.R;

/**
 * Created by adam on 17.01.16.
 */
public class MessageViewAdapter extends RecyclerView.Adapter<MessageViewAdapter.ViewHolder> {

    private List<Message> mDataset;

    public static class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout mView;
        private int mPosition;
        public ViewHolder(LinearLayout v) {
            super(v);
            mView = v;

            mPosition = getAdapterPosition();
        }

        public View getView(){
            return mView;
        }

    }

    public MessageViewAdapter(List<Message> messages){
        mDataset = messages;
    }

    @Override
    public MessageViewAdapter.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.discussion_list_view, parent, false);
        ViewHolder vh = new ViewHolder((LinearLayout)v);
        return vh;
    }

    @Override
    public void onBindViewHolder(MessageViewAdapter.ViewHolder holder, int position) {
        TextView title = (TextView) holder.getView().findViewById(R.id.discussion_name);
        title.setText(mDataset.get(position).toString());

        TextView author = (TextView) holder.getView().findViewById(R.id.discussion_owner);
        author.setText(mDataset.get(position).getUser());
    }

    @Override
    public int getItemCount() {
        return mDataset.size();
    }
}
