from rest_framework import viewsets, permissions
from app.API.models import API
from app.API.serializers import APISerializer
from app.Discussion.models import Discussion
from app.Discussion.serializers import DiscussionSerializer
from app.Event.models import Event
from app.Event.serializers import EventSerializer
from app.Tag.models import Tag
from app.Tag.serializers import TagSerializer
from django.shortcuts import get_object_or_404
import rest_framework
from rest_framework.response import Response

class TagViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Tag.objects.all()
    serializer_class = TagSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)


class TagApiViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Tag.objects.all()
    serializer_class = TagSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request, *args, **kwargs):
        return Response(status=rest_framework.status.HTTP_400_BAD_REQUEST, data={"Request name of tag! Provide it by '../tag_name/"})

    def retrieve(self, request, pk):
        tag = get_object_or_404(self.queryset, name__iexact=pk)
        queryset = API.objects.filter(tag=tag)
        page = self.paginate_queryset(queryset)
        serializer = APISerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)


class TagEventViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Tag.objects.all()
    serializer_class = TagSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request, *args, **kwargs):
        return Response(status=rest_framework.status.HTTP_400_BAD_REQUEST, data={"Request name of tag! Provide it by '../tag_name/"})

    def retrieve(self, request, pk):
        tag = get_object_or_404(self.queryset, name__iexact=pk)
        queryset = Event.objects.filter(tag=tag)
        page = self.paginate_queryset(queryset)
        serializer = EventSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)

class TagDiscussionViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Tag.objects.all()
    serializer_class = TagSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request, *args, **kwargs):
        return Response(status=rest_framework.status.HTTP_400_BAD_REQUEST, data={"Request name of tag! Provide it by '../tag_name/"})

    def retrieve(self, request, pk):
        tag = get_object_or_404(self.queryset, name__iexact=pk)
        queryset = Discussion.objects.filter(tag=tag)
        page = self.paginate_queryset(queryset)
        serializer = DiscussionSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)