from django.conf.urls import patterns, include, url
from django.contrib import admin
from rest_framework.authtoken import views as token_view
from rest_framework import routers

router = routers.DefaultRouter()

from app.API import views as api_views
from app.Discussion import views as discussion_views

router.register(r'api', api_views.APIViewSet)
router.register(r'discussion', discussion_views.DiscussionViewSet)
router.register(r'message', discussion_views.MessageViewSet)


urlpatterns = patterns('',
    url(r'^api/', include(router.urls)),
    url(r'^api-auth/', include('rest_framework.urls',
        namespace='rest_framework')),
    url(r'^api-token-auth/', token_view.obtain_auth_token),
    url(r'^admin/', include(admin.site.urls)),
)
