# Create your views here.
from rest_framework import viewsets, permissions
from app.API.serializers import APISerializer
from app.Discussion.models import Discussion, Message
from app.Discussion.serializers import MessageSerializer, DiscussionSerializer


class DiscussionViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Discussion.objects.all()
    serializer_class = DiscussionSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

class MessageViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = Message.objects.all()
    serializer_class = MessageSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)