from django.contrib.auth.models import User
from app.Event.models import Event
from app.Localization.models import Localization
from app.Tag.models import Tag

__author__ = 'Rafal'
from django.core.management.base import BaseCommand, CommandError

class Command(BaseCommand):
    help = 'Closes the specified poll for voting'

    def add_arguments(self, parser):
        parser.add_argument('poll_id', nargs='+', type=int)

    def handle(self, *args, **options):
        events = [
            ['Wyjscie na festiwal UAN', False, 'Krakow', 'Klub Studio', 'Antek'],
            ]
        print "Creating Events"
        for event in events:
            print "Create {0}".format(event[0])
            tag = Tag.objects.filter(name=event[2])[0]
            localization = Localization.objects.filter(name=event[3])[0]
            user = User.objects.filter(username=event[4])[0]
            new_event = Event.objects.create(name=event[0], private=event[1], localization=localization, user=user)
            new_event.tag = [tag, ]
            new_event.save()
