import json
from app.API.serializers import APISerializer
from lib.api.API import BaseAPI

__author__ = 'Dominik Rosiek'

class API(BaseAPI):
    resource = "d5629ae6-3450-44fb-becb-4a418f354145"
    site = "https://api.bihapi.pl/dane/krakow"
    methods = ('default', 'object')

    def default(self):
        return json.dumps(self.GET(parameters=self.request.GET.dict()))

    def object(self):
        data = self.GET(parameters=self.request.GET.dict())
        results = []
        for obj in data['results']:
            result = {}
            for property in obj['properties']:
                if property['key'] == 'APTEKI':
                    result['name'] = property['value']
                elif property['key'] == 'OADR_GPS_S':
                    result['latitude'] = property['value']
                elif property['key'] == 'OADR_GPS_D':
                    result['longitude'] = property['value']
            results.append(result)
        return json.dumps(results)
