import json
import requests

__author__ = 'Dominik Rosiek'

class BaseAPI(object):
    resource = None
    site = None
    auth = ('niedzad', 'U6ANV3Xv')
    methods = ()
    verifySSL = False

    def __init__(self, request):
        self.request = request

    def GET(self, parameters = {}):
        parameters['resource'] = self.resource
        r = requests.get(self.site, auth=self.auth, params=parameters, verify=self.verifySSL)
        if r.status_code == 200:
            return r.data.encode('utf-8')
        return False

    def execute(self, method):
        if method in self.methods:
            return getattr(self, method)()
        return False